local mod = get_mod("weapon_customization")

return {
	name = mod:localize("mod_title"),
	description = mod:localize("mod_description"),
	is_togglable = false,
	allow_rehooking = true,
	options = {
		widgets = {
			{["setting_id"] = "group_visible_equipment",
  				["type"] = "group",
				["sub_widgets"] = {
					{["setting_id"] = "mod_option_visible_equipment",
						["type"] = "checkbox",
						["default_value"] = true,
						["tooltip"] = "mod_option_visible_equipment_tooltip",
					},
					{["setting_id"] = "mod_option_visible_equipment_sounds",
						["type"] = "dropdown",
						["default_value"] = "others",
						["tooltip"] = "mod_option_visible_equipment_sounds_tooltip",
						["options"] = {
							{text = "mod_option_visible_equipment_sounds_all", value = "all"},
							{text = "mod_option_visible_equipment_sounds_others", value = "others"},
							{text = "mod_option_visible_equipment_sounds_off", value = "off"},
						}
					},
				},
			},
			{["setting_id"] = "group_weapon_animation",
  				["type"] = "group",
				["sub_widgets"] = {
					{["setting_id"] = "mod_option_weapon_build_animation",
						["type"] = "checkbox",
						["default_value"] = true,
						["tooltip"] = "mod_option_weapon_build_animation_tooltip",
						["sub_widgets"] = {
							{["setting_id"] = "mod_option_weapon_build_animation_speed",
								["type"] = "numeric",
								["default_value"] = 1,
								["range"] = {1, 2},
								["unit_text"] = "mod_option_weapon_build_animation_speed_unit",
								["tooltip"] = "mod_option_weapon_build_animation_speed_tooltip",
								["decimals_number"] = 2
							},
							{["setting_id"] = "mod_option_weapon_build_animation_wobble",
								["type"] = "checkbox",
								["default_value"] = true,
								["tooltip"] = "mod_option_weapon_build_animation_wobble_tooltip",
							},
						},
					},
					{["setting_id"] = "mod_option_camera_zoom",
						["type"] = "checkbox",
						["default_value"] = true,
						["tooltip"] = "mod_option_camera_zoom_tooltip",
					},
				}
			},
			{["setting_id"] = "group_flashlight",
  				["type"] = "group",
				["sub_widgets"] = {
					{["setting_id"] = "mod_option_flashlight_shadows",
						["type"] = "checkbox",
						["default_value"] = true,
						["tooltip"] = "mod_option_flashlight_shadows_tooltip",
					},
					{["setting_id"] = "mod_option_flashlight_flicker",
						["type"] = "checkbox",
						["default_value"] = true,
						["sub_widgets"] = {
							{["setting_id"] = "mod_option_flashlight_flicker_start",
								["type"] = "checkbox",
								["default_value"] = true,
								["tooltip"] = "mod_option_flashlight_flicker_start_tooltip",
							},
						},
					},
				},
			},
			{["setting_id"] = "group_laser_pointer",
  				["type"] = "group",
				["sub_widgets"] = {
					{["setting_id"] = "mod_option_deactivate_crosshair",
						["type"] = "checkbox",
						["default_value"] = true,
						["tooltip"] = "mod_option_deactivate_crosshair_tooltip",
					},
					{["setting_id"] = "mod_option_laser_pointer_dot_size",
						["type"] = "numeric",
						["default_value"] = 1,
						["range"] = {.5, 1},
						["decimals_number"] = 2,
						["tooltip"] = "mod_option_laser_pointer_dot_size_tooltip",
					},
					{["setting_id"] = "mod_option_laser_pointer_wild",
						["type"] = "checkbox",
						["default_value"] = false,
						["tooltip"] = "mod_option_laser_pointer_wild_tooltip",
					},
					{["setting_id"] = "mod_option_laser_pointer_weapon_dot",
						["type"] = "checkbox",
						["default_value"] = true,
						["tooltip"] = "mod_option_laser_pointer_weapon_dot_tooltip",
					},
					{["setting_id"] = "mod_option_laser_pointer_hit_indicator",
						["type"] = "checkbox",
						["default_value"] = false,
						["tooltip"] = "mod_option_laser_pointer_hit_indicator_tooltip",
						["sub_widgets"] = {
							{["setting_id"] = "mod_option_laser_pointer_hit_indicator_brightness",
								["type"] = "numeric",
								["default_value"] = 1,
								["range"] = {.5, 2},
								["decimals_number"] = 2,
								["tooltip"] = "mod_option_laser_pointer_hit_indicator_brightness_tooltip",
							},
							{["setting_id"] = "mod_option_laser_pointer_hit_indicator_size",
								["type"] = "numeric",
								["default_value"] = 1,
								["range"] = {.25, 2},
								["decimals_number"] = 2,
								["tooltip"] = "mod_option_laser_pointer_hit_indicator_size_tooltip",
							},
							{["setting_id"] = "mod_option_laser_pointer_hit_color",
								["type"] = "dropdown",
								["default_value"] = "red",
								["tooltip"] = "mod_option_laser_pointer_hit_color_tooltip",
								["options"] = {
									{text = "mod_option_laser_pointer_hit_color_white", value = "white"},
									{text = "mod_option_laser_pointer_hit_color_yellow", value = "yellow"},
									{text = "mod_option_laser_pointer_hit_color_red", value = "red"},
									{text = "mod_option_laser_pointer_hit_color_green", value = "green"},
									{text = "mod_option_laser_pointer_hit_color_blue", value = "blue"},
									{text = "mod_option_laser_pointer_hit_color_gold", value = "gold"},
								}
							},
							{["setting_id"] = "mod_option_laser_pointer_hit_weakspot_color",
								["type"] = "dropdown",
								["default_value"] = "blue",
								["tooltip"] = "mod_option_laser_pointer_hit_weakspot_color_tooltip",
								["options"] = {
									{text = "mod_option_laser_pointer_hit_color_white", value = "white"},
									{text = "mod_option_laser_pointer_hit_color_yellow", value = "yellow"},
									{text = "mod_option_laser_pointer_hit_color_red", value = "red"},
									{text = "mod_option_laser_pointer_hit_color_green", value = "green"},
									{text = "mod_option_laser_pointer_hit_color_blue", value = "blue"},
									{text = "mod_option_laser_pointer_hit_color_gold", value = "gold"},
								}
							},
							{["setting_id"] = "mod_option_laser_pointer_hit_critical_color",
								["type"] = "dropdown",
								["default_value"] = "yellow",
								["tooltip"] = "mod_option_laser_pointer_hit_critical_color_tooltip",
								["options"] = {
									{text = "mod_option_laser_pointer_hit_color_white", value = "white"},
									{text = "mod_option_laser_pointer_hit_color_yellow", value = "yellow"},
									{text = "mod_option_laser_pointer_hit_color_red", value = "red"},
									{text = "mod_option_laser_pointer_hit_color_green", value = "green"},
									{text = "mod_option_laser_pointer_hit_color_blue", value = "blue"},
									{text = "mod_option_laser_pointer_hit_color_gold", value = "gold"},
								}
							},
							{["setting_id"] = "mod_option_laser_pointer_kill_color",
								["type"] = "dropdown",
								["default_value"] = "gold",
								["tooltip"] = "mod_option_laser_pointer_kill_color_tooltip",
								["options"] = {
									{text = "mod_option_laser_pointer_hit_color_white", value = "white"},
									{text = "mod_option_laser_pointer_hit_color_yellow", value = "yellow"},
									{text = "mod_option_laser_pointer_hit_color_red", value = "red"},
									{text = "mod_option_laser_pointer_hit_color_green", value = "green"},
									{text = "mod_option_laser_pointer_hit_color_blue", value = "blue"},
									{text = "mod_option_laser_pointer_hit_color_gold", value = "gold"},
								}
							},
						},
					},
				}
			},
			{["setting_id"] = "group_debug",
  				["type"] = "group",
				["sub_widgets"] = {
					{["setting_id"] = "mod_option_debug",
						["type"] = "checkbox",
						["default_value"] = false,
						["sub_widgets"] = {
							{["setting_id"] = "reposition_x_neg",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "reposition_x_neg",
							},
							{["setting_id"] = "reposition_x_pos",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "reposition_x_pos",
							},
							{["setting_id"] = "reposition_y_neg",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "reposition_y_neg",
							},
							{["setting_id"] = "reposition_y_pos",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "reposition_y_pos",
							},
							{["setting_id"] = "reposition_z_neg",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "reposition_z_neg",
							},
							{["setting_id"] = "reposition_z_pos",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "reposition_z_pos",
							},
							{["setting_id"] = "rerotate_x_neg",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "rerotate_x_neg",
							},
							{["setting_id"] = "rerotate_x_pos",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "rerotate_x_pos",
							},
							{["setting_id"] = "rerotate_y_neg",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "rerotate_y_neg",
							},
							{["setting_id"] = "rerotate_y_pos",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "rerotate_y_pos",
							},
							{["setting_id"] = "rerotate_z_neg",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "rerotate_z_neg",
							},
							{["setting_id"] = "rerotate_z_pos",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "rerotate_z_pos",
							},
							{["setting_id"] = "test_index",
								["type"] = "keybind",
								["default_value"] = {},
								["keybind_trigger"] = "pressed",
								["keybind_type"] = "function_call",
								["function_name"] = "inc_test_index",
							},
						}
					},
				}
			},
		},
	},
}
